(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7915,        242]*)
(*NotebookOutlinePosition[      8621,        267]*)
(*  CellTagsIndexPosition[      8577,        263]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Subsubsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n \"F[func_]\" que act\[UAcute]a sobre una funci\
\[OAcute]n \"func\" y la convierte en la funci\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`\(F[func]\)[x] = x - \ func[1.0 - x]/3. \)]],
  " (consulta el comando \"Function\" en la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). \n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Partiendo de la funci\[OAcute]n identidad \"Identity\" itera la funci\
\[OAcute]n antes definida 15 veces. Representa gr\[AAcute]ficamente las \
funciones as\[IAcute] obtenidas en el intervalo [-100,100]. \
\[DownQuestion]Converge la sucesi\[OAcute]n de iteradas as\[IAcute] definida? \
Calcula la posible funci\[OAcute]n l\[IAcute]mite. Repite el proceso anterior \
partiendo inicialmente de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[x] = x\^2\)]],
  ". Comenta los resultados obtenidos.\nSugerencias: Es conveniente usar \
\"Table\", \"Simplify\" y \"Nest\" en vez de \"NestList\" que no va bien para \
lo que queremos. \n",
  StyleBox["c)",
    FontWeight->"Bold"],
  "  Define una funci\[OAcute]n \"H[func_]\" que act\[UAcute]a sobre una \
funci\[OAcute]n \"func\" y la convierte en la funci\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(H[func]\)[x] = Sin[x] + 5. \ Cos[func[1.0 - x]]\)]],
  ".  Partiendo de la funci\[OAcute]n identidad \"Identity\" itera la funci\
\[OAcute]n H 5 veces. Representa gr\[AAcute]ficamente las funciones as\
\[IAcute] obtenidas en el intervalo [-1,1]. \[DownQuestion]Converge la sucesi\
\[OAcute]n de iteradas as\[IAcute] definida?"
}], "Text"],

Cell[BoxData[
    \(F[func_] := Function[x, x - func[1.0 - x]/3. ]\)], "Input"],

Cell[BoxData[
    \(funciones = 
      Table[Simplify[\(Nest[F, Identity, k]\)[x]], {k, 1, 15}]\)], "Input"],

Cell[BoxData[
    \(\(Plot[Evaluate[funciones], {x, \(-100\), 100}]; \)\)], "Input"],

Cell[BoxData[
    \(limite[x_] := \(-0.375\) + 1.5\ x; \n\(F[limite]\)[x] // Simplify\)], 
  "Input"],

Cell[BoxData[{
    \(f[x_] := x^2\), 
    \(funciones = Table[Simplify[\(Nest[F, f, k]\)[x]], {k, 1, 15}]\), 
    \(\(Plot[Evaluate[funciones], {x, \(-100\), 100}]; \)\)}], "Input"],

Cell[BoxData[
    \(H[func_] := Function[x, Sin[x] + 5. \ Cos[func[1.0 - x]]]\)], "Input"],

Cell[BoxData[
    \(\(funciones = Table[\(Nest[H, Identity, k]\)[x], {k, 1, 5}]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Plot[Evaluate[funciones], {x, \(-1\), 1}]; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsubsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Dado un problema de valores iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((x)\) = f(x, y(x)), \ y(a) = \[Alpha]\)]],
  ", define la sucesi\[OAcute]n de las iteradas de Picard partiendo de la \
funci\[OAcute]n inicial constante igual a \[Alpha]. \nSugerencia. No olvides \
hacer la definici\[OAcute]n de forma que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " recuerde las iteradas que ha calculado.\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  "Calcula las primeras 5 iteradas de Picard para los problemas de valores \
iniciales:\n",
  Cell[BoxData[
      \(TraditionalForm\`y' = x + Sin[x] + \ 9  y\ /10\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ y(0) = 1\)\)]],
  " \n",
  Cell[BoxData[
      \(TraditionalForm\`y' = x + 1/3\ y\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y(1/2) = 1/2\)]],
  "\n",
  Cell[BoxData[
      \(TraditionalForm\`y' = x\ Exp[x] + 5  y\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 1\)]],
  "\nEn cada caso calcula la soluci\[OAcute]n exacta con el comando \
\"DSolve\". Elige intervalos apropiados para representar gr\[AAcute]ficamente \
las iteradas obtenidas en cada caso y comp\[AAcute]ralas con la soluci\
\[OAcute]n exacta. En el \[UAcute]ltimo caso puedes calcular m\[AAcute]s \
iteradas para estudiar si hay convergencia. Comenta los resultados \
obtenidos."
}], "Text"],

Cell[BoxData[{
    \(Picard[f_, a_, \[Alpha]_, x_, 1] := N[\[Alpha]]\), 
    \(Picard[f_, a_, \[Alpha]_, x_, n_] := 
      \(Picard[f, a, \[Alpha], x, n] = 
        N[\[Alpha]] + 
          Integrate[f[s, Picard[f, a, \[Alpha], s, n - 1]], {s, a, x}]\)\)}], 
  "Input"],

Cell[BoxData[
    \(f[x_, y_] := x + Sin[x] + \(9/10\ y\ \)\)], "Input"],

Cell[BoxData[
    \(funciones = 
      Table[Chop[Expand[Simplify[Picard[f, 0, 1, x, k]]]], {k, 1, 10}]\)], 
  "Input"],

Cell[BoxData[
    \(solucion = 
      DSolve[{\(y'\)[x] == x + Sin[x] + 9/10\ \ y[x], y[0] \[Equal] 1}, y, x]
        \)], "Input"],

Cell[BoxData[
    \(Plot[Evaluate[funciones], {x, \(-3\), 3}]\)], "Input"],

Cell[BoxData[
    \(Plot[{funciones[\([5]\)], y[x] /. solucion}, {x, \(-3\), 3}, 
      PlotStyle \[Rule] {Hue[ .5], Hue[0]}]\)], "Input"],

Cell[BoxData[
    \(Clear[f]\)], "Input"],

Cell[BoxData[
    \(\(f[x_, y_] := x + y^2; \)\)], "Input"],

Cell[BoxData[
    \(funciones = 
      Table[Expand[Simplify[Picard[f, 1/2, 1/2, x, k]]], {k, 1, 5}]\)], 
  "Input"],

Cell[BoxData[
    \(solucion = 
      DSolve[{\(y'\)[x] \[Equal] x\  + \ y[x]^2, y[ .5] \[Equal]  .5}, y, x]
        \)], "Input"],

Cell[BoxData[
    \(Plot[Evaluate[funciones], {x, \(-1\), 1}, 
      PlotRange \[Rule] {\(- .1\), 1.5}]\)], "Input"],

Cell[BoxData[
    \(Plot[{funciones[\([5]\)], y[x] /. solucion}, {x, \(-1\), 1}, 
      PlotRange \[Rule] {\(- .1\), 1.5}, PlotStyle \[Rule] {Hue[ .5], Hue[0]}]
      \)], "Input"],

Cell[BoxData[
    \(Clear[f]\)], "Input"],

Cell[BoxData[
    \(f[x_, y_] := x*Exp[x] + 5  y\)], "Input"],

Cell[BoxData[
    \(funciones = 
      Table[Expand[Simplify[Picard[f, 0, 1, x, k]]], {k, 1, 15}]\)], "Input"],

Cell[BoxData[
    \(Plot[Evaluate[funciones], {x, \(-1\), 4}]\)], "Input"],

Cell[BoxData[
    \(solucion = 
      DSolve[{\(y'\)[x] \[Equal] x*Exp[x] + y[x], y[0] == 1}, y, x]\)], 
  "Input"],

Cell[BoxData[
    \(Do[Plot[{funciones[\([k]\)], y[x] /. solucion}, {x, \(-1\), 1}, 
        PlotStyle \[Rule] {Hue[ .5], Hue[0]}, 
        PlotRange \[Rule] {\(-1\), 4}], {k, 1, 15}]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1152}, {0, 799}},
WindowSize->{1123, 724},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 36, 0, 55, "Subsubsection"],
Cell[1770, 53, 1671, 35, 285, "Text"],
Cell[3444, 90, 79, 1, 72, "Input"],
Cell[3526, 93, 108, 2, 72, "Input"],
Cell[3637, 97, 84, 1, 72, "Input"],
Cell[3724, 100, 101, 2, 98, "Input"],
Cell[3828, 104, 181, 3, 124, "Input"],
Cell[4012, 109, 90, 1, 72, "Input"],
Cell[4105, 112, 99, 2, 72, "Input"],
Cell[4207, 116, 80, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4324, 122, 36, 0, 55, "Subsubsection"],
Cell[4363, 124, 1440, 39, 339, "Text"],
Cell[5806, 165, 269, 6, 124, "Input"],
Cell[6078, 173, 72, 1, 72, "Input"],
Cell[6153, 176, 119, 3, 72, "Input"],
Cell[6275, 181, 131, 3, 72, "Input"],
Cell[6409, 186, 74, 1, 72, "Input"],
Cell[6486, 189, 138, 2, 72, "Input"],
Cell[6627, 193, 41, 1, 72, "Input"],
Cell[6671, 196, 59, 1, 72, "Input"],
Cell[6733, 199, 116, 3, 72, "Input"],
Cell[6852, 204, 130, 3, 72, "Input"],
Cell[6985, 209, 116, 2, 72, "Input"],
Cell[7104, 213, 180, 3, 98, "Input"],
Cell[7287, 218, 41, 1, 72, "Input"],
Cell[7331, 221, 61, 1, 72, "Input"],
Cell[7395, 224, 110, 2, 72, "Input"],
Cell[7508, 228, 74, 1, 72, "Input"],
Cell[7585, 231, 115, 3, 72, "Input"],
Cell[7703, 236, 196, 3, 124, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

